; ==========================================================
; Fnuque 2K Intro Base - A minimal Amiga intro template
; 
; Uses Tricky Tracker for music playback.
; Tested on A500 (OCS) and A1200 (AGA).
; ==========================================================

    section	c,code_c     ; Code section in chip memory

    ; Init (before screen setup)
    lea	    $dff000,a6          ; Load custom chip base address into a6

    ; Initialize Tricky Tracker
    bsr     Tricky_Init

    ; TODO: Add any precalc here

    ; Now install copper list (enables audio DMA)
    move.l	#Copper,$080(a6)     ; Install our Copper list
    move.w  #$4000,$09a(a6)     ; INTENA - disable ALL interrupts

    ; Main program loop - wait for user input
MainLoop:

    ; wait for vertical blank
    move.b  $bfe801,d0
.wait:
    cmp.b   $bfe801,d0
    beq.b   .wait

    ; Set bitplane pointers every frame
    move.l  ScreenPointer,a1
    lea     $0e0(a6),a2
    rept 5
	move.l	a1,(a2)+ 	; set bitplane pointer
	add.w	#320/8*256,a1	; increase pointer to next bpl
    endr

    bsr.w   Tricky_Play         ; Play music

    ; draw something 
    lea.l  Screen,a0
    move.l  Tricky_VBlank,d7
    move.w  d7,colors+2 ; Change color 0

    btst.b	#6,$bfe001      ; Test left mouse button (bit 6 of $bfe001, active low)
    bne.b	MainLoop        ; If button not pressed (bit=1), loop back
.exitDemo:
    ;--------------------------------------------------------------------
    ; Exit - clean up and restore system
    ;--------------------------------------------------------------------

    move.l	$4.w,a0         ; Get ExecBase address from $4
    move.l	156(a0),a0      ; Get graphics.library base from ExecBase
    move.l	38(a0),$080(a6) ; Restore system's original Copper list

    move.w  #$c000,$09a(a6)     ; INTENA - enable ALL interrupts

    ; Silence all audio channels
    moveq.l #0,d0
    lea    $00a6(a6),a2
    move.w  d0,(a2)   ; AUD0VOL = 0
    add.w   #16,a2
    move.w  d0,(a2)   ; AUD1VOL = 0
    add.w   #16,a2
    move.w  d0,(a2)   ; AUD2VOL = 0
    add.w   #16,a2
    move.w  d0,(a2)   ; AUD3VOL = 0

    rts                     ; Return to system/caller

    ;--------------------------------------------------------------------
    ; includes 
    ;--------------------------------------------------------------------

    ; include the music playback code
    include "5percent-final-code.s"

; ==========================================================
; Data
; ==========================================================
ScreenPointer:
    dc.l    Screen

    ; include song data
    include "5percent-final-data.s"

    CNOP 0,4
Copper:
    ; Display setup
    dc.w	$0100,$5200 ; BPLCON0: 5 bitplanes + COLOR
	dc.w	$0102,$0000 ; BPLCON1 - Horizontal scroll
	dc.w	$0104,$0024 ; BPLCON2 - Sprite/playfield priority
    dc.w	$0106,$0000 ; BPLCON3 - A1200/AGA compatibility
    dc.w	$0108,$0000 ; BPL1MOD - modulo for odd bitplanes (0 = sequential)
    dc.w	$010a,$0000 ; BPL2MOD - modulo for even bitplanes (0 = sequential)
    dc.w	$008e,$2c81	; DIWSTRT - Display window start
    dc.w	$0090,$2cc1 ; DIWSTOP - Display window stop
    dc.w	$0092,$0038 ; DDFSTRT - Display data fetch start 
    dc.w	$0094,$00d0 ; DDFSTOP - Display data fetch stop
    dc.w    $0096,$800F ; DMACON - SET + enable audio DMA (all 4 channels)
    dc.w    $0096,$0020 ; DMACON - disable sprite DMA
    dc.w	$01fc,$0000 ; FMODE - A1200/AGA: OCS/ECS fetch mode
colors:
    dc.w    $0180,$0000
    dc.w    $0182,$0fff
    dc.l	-2          ; End of Copper list

Screen:
    ds.b    320*256/8*5 ; 320x256 screen buffer (5 bitplanes)

