# TrickyTracker for ProTracker Users

---

## Core Concepts

| ProTracker | TrickyTracker | 
|------------|---------------|
| Pattern (64 rows) |
| Sample slots (1-31) | Instruments (1-8) |
| Pattern order list | Arrangement grid | 
| .MOD file | .TT file (JSON) |

---

## The Big Differences

### Segments, Not Patterns

- **Segments are 16 rows**, not 64.
- Each channel can play a **different segment** at the same time.
- Enables polymetric arrangements.

### Per-Channel Arrangement

- The **Arrangement View** (top) shows which segment each channel plays at each position.
- Click a cell to assign a segment. Channels are independent.

### No Samples

- All sounds generated from **waveform archetypes** (Sine, Square, Saw, Noise).

---

## Instrument Editing

Each instrument is two waveforms blended together:
- **Primary** waveform at base pitch
- **Secondary** waveform at an optional different octave (set by PER)
- Blended by MIX ratio, then shaped by volume/pitch slides over time

### Waveform Selection
- **Left-click** waveform: cycle forward (Sine → Square → Saw → Noise)
- **Right-click** waveform: cycle backward

### Sliders
| Slider | Range | Function |
|--------|-------|----------|
| PER | 0-4 | Secondary period multiplier (×1, ×4, ×8, ×16, ×32) — higher = lower pitch |
| MIX | 1-4 | Blend ratio (see table below) |
| VOL | 0-64 | Base volume |
| VSL | -32 to +31 | Volume slide per tick (negative = fade out) |
| PSL | -32 to +31 | Pitch slide per tick (negative = pitch down) |

**MIX values:**

| MIX | Primary | Secondary |
|-----|---------|-----------|
| 1 | 50% | 50% |
| 2 | 75% | 25% |
| 3 | 87% | 13% |
| 4 | 94% | 6% |

- **Double-click** a slider to reset to default.
- **R** to rename selected instrument.
- **C/P buttons** (top-right of slot): Copy/Paste instrument.

---

## Tracker Panel

### Segment Badges
- Each channel column shows a **circled number** = which segment plays there.
- **Left-click** badge: increment segment.
- **Right-click** badge: decrement segment.

### Navigation
- **Arrow keys**: move edit cursor.
- **Tab / Shift+Tab**: move right/left.
- **Page Up/Down**: jump 16 rows (full segment).
- **Click** in grid: set edit cursor position.

### Editing
- **Piano keys** (see below): enter note (requires Record mode).
- **Delete/Backspace**: clear note.
- **T**: insert note-off (kill).
- **Ctrl+C / Ctrl+V**: copy/paste segment.
- **Ctrl+X**: clear entire segment.
- **Ctrl+1-8**: change instrument of current note.
- **F8 / Shift+F8**: transpose semitone/octave down.
- **F9 / Shift+F9**: transpose semitone/octave up.

---

## Arrangement View

- **Click** to focus. Arrow keys navigate.
- **Shift+Arrow**: extend selection.
- **Page Up/Down**: increment/decrement segment ID.
- **Ctrl+C / Ctrl+V**: copy/paste block.
- **Delete**: clear selected cells.
- **Ctrl+Insert**: insert row.
- **Ctrl+Delete**: delete row.
- **Escape**: clear selection.

---

## Keyboard Reference

### Playback
| Key | Action |
|-----|--------|
| F5 / Right Shift | Play/Stop |
| Ctrl+F5 / Ctrl+Shift | Play from cursor |
| F6 | Rewind (stop + reset) |
| F7 / Space | Toggle record mode |
| Escape | Stop playback |
| Enter | Preview current row |

### Global
| Key | Action |
|-----|--------|
| 1-8 | Select instrument |
| Shift+1-4 | Mute/unmute channel |
| F1 / F2 | Octave down/up |
| F4 | Help |
| Ctrl+Z / Ctrl+Y | Undo / Redo |
| Ctrl+N / Ctrl+O / Ctrl+S | New / Open / Save |
| Ctrl+E | Export to assembly |
| Ctrl+I | Project info |

### Note Entry
White keys: `Z X C V B N M , .` (C to D+1)
Black keys: `S D G H J L` (C# D# F# G# A# C#+1)

---

## What's Missing (By Design)

- No sample import 
- No effects column — volume/pitch slides are per-instrument.
- No pattern break/jump — arrangement handles song structure.

---

## Project Info (Ctrl+I)

Shows export statistics to help optimize size:
- **Notes**: which notes are used and how often
- **Instruments**: usage count per instrument
- **Segments**: usage count per segment

Single-use items are highlighted — candidates for inlining/removal to save bytes when compressing the module.

---

## Export

Exports to **68000 assembly** for Amiga:
- `Tricky_Init` — call once to set up audio
- `Tricky_Play` — call every VBlank for playback
