; ------------------------------------------------------------------
; TrickyTracker CODE export - auto-generated
; ------------------------------------------------------------------
; Project    : 5percent-final
; ------------------------------------------------------------------

; Archetype shift calculation: lsl #7
; (Converts instrument header offset to merged sample offset)

TRICKY_SEGMENT_SIZE_SHIFT = 4
TRICKY_SEGMENT_SIZE=(1<<TRICKY_SEGMENT_SIZE_SHIFT)

; Archetype generation settings
TRICKY_ARCHETYPE_SIZE_WORDS = 1024
TRICKY_ARCHETYPE_SIZE_BYTES = TRICKY_ARCHETYPE_SIZE_WORDS*2
TRICKY_WAVEFORM_PERIOD = 32         ; base waveform period in words

; Archetype indices (for generationData table) - ror #5 to get byte offset
ARCH_SINE   = 0
ARCH_SQUARE = 1
ARCH_SAW    = 2
ARCH_NOISE  = 3

; ------------------------------------------------------------------
; Initialization routine
; ------------------------------------------------------------------
Tricky_Init:
        ; Initialize all audio channels to safe values BEFORE enabling DMA
        moveq.l #16,d0
        lea     $00a4(a6),a2
        move.w  d0,(a2)             ; AUD0LEN
        add.w   #16,a2
        move.w  d0,(a2)             ; AUD1LEN
        add.w   #16,a2
        move.w  d0,(a2)             ; AUD2LEN
        add.w   #16,a2
        move.w  d0,(a2)             ; AUD3LEN

        ; --- Convert note indices to periods ---
        lea     segments+2,a0       ; start at first note word
        lea     note_table,a1       ; note frequency table
        move.w  #(segments_end-segments)/4-1,d7
.initSeg:
        move.w  (a0),d0                 ; get note index
        add.w   d0,d0                   ; word offset
        move.w  (a1,d0),(a0)            ; store frequency
        addq.l  #4,a0                   ; next word pair
        dbf     d7,.initSeg

        ; --- Generate archetypes ---
        lea     archetypeBuffers,a1 ; base of archetype buffers
        lea     sineTemplate,a0

        ; Archetype 0: Sine (tile 32-word template)
        bsr     .tileWaveform

        ; Archetype 1: Square (tile 32-word template)
        lea     squareTemplate,a0
        bsr     .tileWaveform

        ; Archetype 2: Saw (generate and tile)
        bsr     .generateSaw

        ; Archetype 3: Noise (generate signed words via LFSR)
        move.w  #TRICKY_ARCHETYPE_SIZE_WORDS-1,d7
        move.w  #$DEAD,d0               ; LFSR seed
.genNoise:
        lsr.w   #1,d0
        bcc.b   .noFeedback
        eor.w   #$B400,d0
.noFeedback:
        move.w  d0,d1                   ; full LFSR value
        asr.w   #8,d1                   ; arithmetic shift right, sign-extends from high byte
        move.w  d1,(a1)+                ; store as word sample
        dbf     d7,.genNoise

        ; --- Generate blended instruments ---
        lea     archetypeBuffers,a0
        lea     mergedInstruments,a2
        lea     generationData,a1
        moveq.l #(generationData_end-generationData)/8-1,d7
.genLoop:
        movem.w (a1)+,d0-d3             ; d0=primary index, d1=secondary index, d2=mix, d3=secondary_shift
        ror.w   #5,d0                   ; index -> byte offset (ror 5 = lsl 11 for clean words)
        ror.w   #5,d1
        lea     (a0,d0.w),a3        ; primary waveform address
        lea     (a0,d1.w),a4        ; secondary waveform address

        ; --- Inline blend: mix two word archetypes into byte output ---
        ; Formula: result = ((primary << mix) - primary + secondary) >> mix
        move.w  #TRICKY_ARCHETYPE_SIZE_WORDS-1,d6
        moveq.l #0,d4                    ; sample counter for secondary stepping
.blendLoop:
        move.w  (a3)+,d0                ; primary sample (word)
        move.w  d4,d5                   ; copy sample counter
        lsr.w   d3,d5                   ; secondary_index = counter >> secondary_shift
        add.w   d5,d5                   ; word offset (d5 *= 2)
        move.w  (a4,d5.w),d1            ; secondary sample (word) using computed offset
        move.w  d0,d5                   ; reuse d5 as temp = primary
        asl.w   d2,d5                   ; temp = primary << mix
        sub.w   d0,d5                   ; temp = (primary<<mix)-primary
        add.w   d1,d5                   ; temp += secondary
        asr.w   d2,d5                   ; temp = result >> mix
        move.b  d5,(a2)+                ; store as byte
        addq.w  #1,d4                   ; increment sample counter
        dbf     d6,.blendLoop
        dbf     d7,.genLoop

        rts

; --- Tile a 32-word waveform to fill 1024 words ---
; a0 = source (32 words = 64 bytes), a1 = destination (1024 words = 2048 bytes)
.tileWaveform:
        moveq.l #(TRICKY_ARCHETYPE_SIZE_WORDS/TRICKY_WAVEFORM_PERIOD)-1,d6
.tileOuter:
        move.l  a0,a3                   ; reset source to template start
        moveq.l #TRICKY_WAVEFORM_PERIOD-1,d7
.tileInner:
        move.w  (a3)+,(a1)+
        dbf     d7,.tileInner
        dbf     d6,.tileOuter
        rts

; --- Generate sawtooth: ramp from -128 to 127 as words, tiled ---
; a1 = destination (1024 words = 2048 bytes)
.generateSaw:
        moveq.l #(TRICKY_ARCHETYPE_SIZE_WORDS/TRICKY_WAVEFORM_PERIOD)-1,d6
.sawTileLoop:
        moveq.l #-128,d0
        moveq.l #TRICKY_WAVEFORM_PERIOD-1,d7
.sawLoop:
        move.w  d0,(a1)+
        addq.w  #8,d0
        dbf     d7,.sawLoop
        dbf     d6,.sawTileLoop
        rts


; ------------------------------------------------------------------
; Playback routine - call once per VBlank
; Requires: a6 = $dff000 (custom chip base)
; ------------------------------------------------------------------
Tricky_Play:
        ; -------- apply volume and pitch slide -------------------
        lea     volumeAndPitch,a3   ; volume and pitch data
        lea     modifiers,a4        ; playback modifiers
        lea     $00a0(a6),a2            ; start at AUD0PER for modifier writes

        moveq.l #4-1,d7      ; 4 channels, 2 modifiers each
.modLoop:
        movem.w (a3)+,d0-d1     ; d0 = pitch, d1 = volume
        movem.w (a4)+,d2-d3     ; d2 = delta pitch, d3 = delta volume
        add.w   d2,d0
        bpl.b   .positivePitch
        moveq.l #0,d0
.positivePitch:
        add.w   d3,d1
        bpl.b   .positiveVol
        moveq.l #0,d1
.positiveVol:
        cmp.b   #64,d1  ; max vol
        ble.b   .volInRange
        moveq.l #64,d1
.volInRange:
        movem.w d0-d1,-4(a3)
        movem.w d0-d1,6(a2)  ; and importantly, set volume/frequency
        add.w   #16,a2
        dbf     d7,.modLoop

        ; -------- tick check -----------------------------------
        move.l  Tricky_VBlank,d0   ; playpos based on vblank
        addq.l  #1,Tricky_VBlank       ; increment VBlank counter
        move.l  d0,d1        ;  backup vblank

        ; one tick is every Nth frame (normal: 3 => every 8 VBlanks)
        and.b   #(1<<3)-1,d0
        beq.b   .tick
        rts
.tick:

        ; convert to tracker segment rows
        lsr.l   #3,d1

        ; convert track position to segment index
        move.l  d1,d0       ; copy raw track position, to calc

        lsr.l   #TRICKY_SEGMENT_SIZE_SHIFT,d0  ; segment_index
        and.w   #(TRICKY_SEGMENT_SIZE-1),d1  ; get in-segment pos [0-15]

        movem.w d0-d1,Tricky_Segment   ; store for effect sync

        ; alright boys, we have a segment index and an offset,
        ; let's play some music

        ; stop playback at end of song
        cmp.w   #(channel_arrangements_end-channel_arrangements)/8,d0
        blt.b   .song_ok
        rts
.song_ok:

        lea     channel_arrangements,a0     ; size: words
        add.w   d0,d0           ; word offset
        add.w   d0,a0           ; find the current segment id in the arrangement

        sub.w   #16,a3          ; reset a3/a4 (same size as lea, but packs better)
        sub.w   #16,a4
        lea     $00a0(a6),a2            ; AUD0 base (LC/LEN/PER/VOL)
        move.w  #TRICKY_ARCHETYPE_SIZE_WORDS/2,d2
        moveq.l #4-1,d7      ; channel counter
.loop:
        move.w  (a0),d0 ; segment index for this channel (word)

        ; scale up the index to match segment size to find byte offset
        lsl.w   #TRICKY_SEGMENT_SIZE_SHIFT,d0
        add.w   d1,d0        ; add in-segment offset [0-15]

        lsl.w   #2,d0        ; shift for LW offset, they come as [instId, period] words
        lea     segments,a1   ; size: word pairs
        add.w   d0,a1       ; now a1 points to instrument+note word pair
        move.l  (a1)+,d0     ; instrument id + note (period)

        beq.b   .no_note        ; skip if no note ($0000,$0000)

        ; ok, d0 = [instrument id, note period]
        move.w  d0,d3     ; keep raw period for later register write
        swap    d0          ; switch lower word to instrument id
        lsl.w   #3,d0        ; convert id to offset - 8 bytes per instrument
        lea     instrument_data,a1
        add.w   d0,a1       ; get instrument data offset

        lsl.w   #7,d0      ; instrument_data offset --> merged_sample offset

        ; d0 now contains [waveform byte offset : base volume]
        move.l  (a1)+,d5
        move.w  d5,d4        ; cache volume
        move.w  d5,2(a3)      ; store volume in channel table
        move.l  (a1),(a4)  ; set modifier table for channel

        move.w  d3,(a3)       ; remember last written period

        move.l  a0,-(sp)    ; preserve arrangement pointer
        lea     mergedInstruments,a0
        adda.w  d0,a0        ; a0 = source for BlitCopy

        moveq.l #3,d5       ; channel index = 3-d7 (d7 counts 3..0)
        sub.w   d7,d5
        mulu    #1024,d5    ; byte offset into ChannelWaveBuffers
        lea     ChannelWaveBuffers,a1
        adda.w  d5,a1       ; a1 = destination buffer for this channel

; Inline BlitCopy: a0 = source, a1 = dest, copies 1024 bytes (512 words)
.bwait:
        btst.b  #14-8,$002(a6)        ; DMACONR high byte
        bne.b   .bwait

        move.l  #$09f00000,d0         ; BLTCON0/1: A->D copy
        moveq.l #-1,d5                ; BLTAFWM/BLTALWM
        movem.l d0/d5/d6/d7/a0/a1,$040(a6)  ; blast 6 regs to blitter
        move.w  #0,$064(a6)           ; BLTAMOD
        move.w  #0,$066(a6)           ; BLTDMOD
        move.w  #8<<6|0,$058(a6)      ; BLTSIZE: 64 words × 8 = 512 words

        move.l  (sp)+,a0    ; restore arrangement pointer

        move.l  a1,(a2)         ; set AUDxLCH/AUDxLCL (sample pointer)
        movem.w d2-d4,4(a2)     ; set AUDxLEN, AUDxPER and volume

.no_note:
        adda.w  #16,a2       ; next audio channel registers
        adda.w  #(channel_arrangements_end-channel_arrangements)/4,a0      ; next channel block
        addq.l  #4,a4       ; next channel modifier
        addq.l  #4,a3       ; next channel volume/pitch

        dbf     d7,.loop


Tricky_Play_Done:
        rts

        ; QOTD: The most important property of a program is whether it accomplishes the intention of its user. - C.A.R. Hoare

